Attribute VB_Name = "WinsockCntrl"
Option Explicit

Public Declare Sub Sleep Lib "Kernel32" (ByVal dwMilliseconds As Long)

Private Const MAX_LENG = 64

' Windows Sockets definitions of regular Microsoft C error constants
Global Const WSAEINTR = 10004
Global Const WSAEACCES = 10013
Global Const WSAEFAULT = 10014
Global Const WSAEINVAL = 10022
Global Const WSAEMFILE = 10024

' Windows Sockets definitions of regular Berkeley error constants
Global Const WSAEWOULDBLOCK = 10035
Global Const WSAEINPROGRESS = 10036
Global Const WSAEALREADY = 10037
Global Const WSAENOTSOCK = 10038
Global Const WSAEDESTADDRREQ = 10039
Global Const WSAEMSGSIZE = 10040
Global Const WSAEPROTOTYPE = 10041
Global Const WSAENOPROTOOPT = 10042
Global Const WSAEPROTONOSUPPORT = 10043
Global Const WSAESOCKTNOSUPPORT = 10044
Global Const WSAEOPNOTSUPP = 10045
Global Const WSAEPFNOSUPPORT = 10046
Global Const WSAEAFNOSUPPORT = 10047
Global Const WSAEADDRINUSE = 10048
Global Const WSAEADDRNOTAVAIL = 10049
Global Const WSAENETDOWN = 10050
Global Const WSAENETUNREACH = 10051
Global Const WSAENETRESET = 10052
Global Const WSAECONNABORTED = 10053
Global Const WSAECONNRESET = 10054
Global Const WSAENOBUFS = 10055
Global Const WSAEISCONN = 10056
Global Const WSAENOTCONN = 10057
Global Const WSAESHUTDOWN = 10058
Global Const WSAETOOMANYREFS = 10059
Global Const WSAETIMEDOUT = 10060
Global Const WSAECONNREFUSED = 10061
Global Const WSAEHOSTDOWN = 10064
Global Const WSAEHOSTUNREACH = 10065
Global Const WSAEPROCLIM = 10067

' Extended Windows Sockets error constant definitions
Global Const WSASYSNOTREADY = 10091
Global Const WSAVERNOTSUPPORTED = 10092
Global Const WSANOTINITIALISED = 10093
Global Const WSAHOST_NOT_FOUND = 11001
Global Const WSATRY_AGAIN = 11002
Global Const WSANO_RECOVERY = 11003
Global Const WSANO_DATA = 11004

Type sockaddr
    sin_family      As Integer                      '
    sin_port        As Integer                      'Port No.
    sin_addr        As Long                         '32-bit Internet address
    sin_zero        As String * 8                   '
End Type

Public Const WSA_DESCRIPTIONLEN = 256
Public Const WSA_DescriptionSize = WSA_DESCRIPTIONLEN + 1
Public Const WSA_SYS_STATUS_LEN = 128
Public Const WSA_SysStatusSize = WSA_SYS_STATUS_LEN + 1

Type WSADataType
    wVersion        As Integer                      'Minor version
    wHighVersion    As Integer                      'Major version
    szDescription   As String * WSA_DescriptionSize 'Vendor information
    szSystemStatus  As String * WSA_SysStatusSize   'WinSock situation
    iMaxSockets     As Integer                      'The number of the maximum sockets
    iMaxUdpDg       As Integer                      'The maximum size which can transmit by UDP protocol.
    lpVendorInfo    As Long                         'The pointer to a buffer including information peculiar to a vendor.
End Type

Public Const SOCKET_ERROR = -1
Public Const SOCK_STREAM = 1
Public Const AF_INET = 2

Public Const COMMAND_ERROR = -1
Public Const RECV_ERROR = -1
Public Const NO_ERROR = 0

'Socket function
Public Declare Function CloseSocket Lib "wsock32.dll" Alias "closesocket" (ByVal s As Long) As Long
Public Declare Function connect Lib "wsock32.dll" (ByVal s As Long, sName As sockaddr, ByVal namelen As Long) As Long
Public Declare Function recv Lib "wsock32.dll" (ByVal s As Long, ByVal buf As Any, ByVal lngLen As Long, ByVal flags As Long) As Long
Public Declare Function send Lib "wsock32.dll" (ByVal s As Long, buf As Any, ByVal lngLenlen As Long, ByVal flags As Long) As Long
Public Declare Function socket Lib "wsock32.dll" (ByVal af As Long, ByVal lngType As Long, ByVal protocol As Long) As Long
'Byte order conversion function
Public Declare Function htons Lib "wsock32.dll" (ByVal hostshort As Long) As Integer
'Address conversion function
Public Declare Function inet_addr Lib "wsock32.dll" (ByVal cp As String) As Long
'others
Public Declare Function WSAStartup Lib "wsock32.dll" (ByVal wVersionRequested As Long, lpWSAData As WSADataType) As Long
Public Declare Function WSACleanup Lib "wsock32.dll" () As Long
Public Declare Function WSAGetLastError Lib "wsock32.dll" () As Long

Public str_U38_TcpipAddress As String
Public str_SG_TcpipAddress As String

Public U38_PortNo As Long
Public SG_PortNo As Long

Public U38_SockID As Long
Public SG_SockID As Long

Public SG_OutputLevel As Single

Public SG_OUTPUT__CMD As String
Public SG_OUT_ON__CMD As String
Public SG_OUT_OFF_CMD As String
Public SG_OUT_LVL_CMD As String
Public SG_OUT_LVL_UNT As String
Public SG_SET_FRQ_CMD As String
Public SG_SET_FRQ_UNT As String

Public TcpipConnect As Boolean          'TCP/IP Connect flag. (False : OFF, True : ON)
Public VCorrAbort As Boolean            'External SG Vector Correction Abort flag. (Abort : True, Not Abort : False)


Public Sub CloseConnect(ByRef mlngSock As Long)
    Dim rtn As Long

    rtn = CloseSocket(mlngSock)
    If rtn = SOCKET_ERROR Then MsgBox ("closesocket : SOCKET_ERROR  = " & CStr(rtn))

End Sub

Public Sub CloseWinsock()
    Dim rtn As Long

    rtn = WSACleanup()                  'Shutdown Winsock DLL
End Sub

Public Sub InitWinsock()
    Dim rtn As Long
    Dim StartInf As WSADataType
        
    rtn = WSAStartup(&H101, StartInf)   'Initialize Winsock
End Sub
 
Public Function OpenSocket(ByRef mlngSock As Long, ByVal strIpAdrs As String, ByVal PortNumber As Integer) As Integer
    Dim musrSockBuf As sockaddr
    Dim IpAdrs As Long
    Dim rtn As Long
    
    IpAdrs = inet_addr(strIpAdrs)

    'Create a new socket
    mlngSock = socket(AF_INET, SOCK_STREAM, 0)
    If mlngSock = SOCKET_ERROR Then
        MsgBox ("OpenSocket : SOCKET_ERROR = " & CStr(mlngSock))
        OpenSocket = COMMAND_ERROR
        Exit Function
    End If
    
    'Open a connection to a server
    musrSockBuf.sin_family = AF_INET
    musrSockBuf.sin_port = htons(PortNumber)
    musrSockBuf.sin_addr = IpAdrs
    musrSockBuf.sin_zero = String$(8, 0)
    rtn = connect(mlngSock, musrSockBuf, Len(musrSockBuf))
    If mlngSock = SOCKET_ERROR Then
        MsgBox ("OpenSocket : SOCKET_ERROR = " & CStr(rtn))
        OpenSocket = COMMAND_ERROR
        Exit Function
    End If
    
    OpenSocket = mlngSock

End Function

'Public Function PutSocket(ByRef mlngSock As Long, ByVal str As String) As Long
'    Dim strPut As String
'    Dim cnt As Long
'
'    strPut = str & vbCrLf
'    cnt = send(mlngSock, ByVal strPut, Len(strPut), 0)
'
'    If cnt = SOCKET_ERROR Then
'        MsgBox ("PutSocket : SOCKET_ERROR " & CStr(cnt))
'        PutSocket = COMMAND_ERROR
'        Exit Function
'    End If
'
'    PutSocket = NO_ERROR
'
'End Function
'
'
'Public Function GetSocket(ByRef mlngSock As Long, ByRef str As String) As Long
'    Dim b As String * 1
'    Dim leng As Long
'    Dim cnt As Long
'    Dim tmp_buf As String * MAX_LENG
'
'    str = ""
'    While leng < MAX_LENG
'        DoEvents
'        cnt = recv(mlngSock, b, 1, 0)
'        If cnt < 1 Then
'            GetSocket = RECV_ERROR
'            tmp_buf = vbNull
'            Exit Function
'        End If
'
'        If b = vbLf Or b = vbCr Then
'           tmp_buf = tmp_buf & vbNull
'            str = Mid(tmp_buf, 1, leng)
'           GetSocket = leng
'           Exit Function
'        End If
'
'        leng = leng + cnt
'        tmp_buf = tmp_buf + b
'    Wend
'
'    GetSocket = RECV_ERROR
'End Function

Function strWSAErrorGet(ByVal vlngErrNum As Long) As String
    On Error Resume Next

    Select Case vlngErrNum
        Case WSAEINTR
            strWSAErrorGet = "ĂяoꂽB"
        Case WSAEACCES
            strWSAErrorGet = "w肳ꂽAhX́Au[hLXgpPbg̑MT|[gĂȂB"
        Case WSAEFAULT
            strWSAErrorGet = "32rbgC^[lbgAhXwɌ肪܂B"
        Case WSAEINVAL
            strWSAErrorGet = "֐̌ĂяoԂɌ肪B"
        Case WSAEMFILE
            strWSAErrorGet = "p\ȃt@Cԍ݂ȂB"
        Case WSAEWOULDBLOCK
            strWSAErrorGet = "̃\Pbg̓mubLO^łB"
        Case WSAEINPROGRESS
            strWSAErrorGet = "ubLOĂяoisB"
        Case WSAEALREADY
            strWSAErrorGet = "mubLO^̏B"
        Case WSAENOTSOCK
            strWSAErrorGet = "\PbgȊOw肵B"
        Case WSAEDESTADDRREQ
            strWSAErrorGet = "[gAhXw肳ĂȂB"
        Case WSAEMSGSIZE
            strWSAErrorGet = "f[^obt@傫̂Ő؂߂ꂽB"
        Case WSAEPROTOTYPE
            strWSAErrorGet = "\Pbg͎w肳ꂽvgRT|[gĂȂB"
        Case WSAENOPROTOOPT
            strWSAErrorGet = "vgR̃IvVɌ肪B"
        Case WSAEPROTONOSUPPORT
            strWSAErrorGet = "w肳ꂽvgR̓T|[gĂȂB"
        Case WSAESOCKTNOSUPPORT
            strWSAErrorGet = "w肳ꂽ\Pbg^Cv̓T|[gĂȂB"
        Case WSAEOPNOTSUPP
            strWSAErrorGet = "w肳ꂽ\PbgT|[gĂȂłB"
        Case WSAEPFNOSUPPORT
            strWSAErrorGet = "w肳ꂽAhXt@~T|[gĂȂB"
        Case WSAEAFNOSUPPORT
            strWSAErrorGet = "w肳ꂽvgRł́Aw肳ꂽAhXt@~T|[gĂȂB"
        Case WSAEADDRINUSE
            strWSAErrorGet = "w肳ꂽAhX͎gpB"
        Case WSAEADDRNOTAVAIL
            strWSAErrorGet = "w肳ꂽAhX͎gpłȂB"
        Case WSAENETDOWN
            strWSAErrorGet = "lbg[N_EĂB"
        Case WSAENETUNREACH
            strWSAErrorGet = "[gzXg̃lbg[NɐڑłȂB"
        Case WSAENETRESET
            strWSAErrorGet = "lbg[NؒfꂽB"
        Case WSAECONNABORTED
            strWSAErrorGet = "lbg[NsǂŐڑ~ꂽB"
        Case WSAECONNRESET
            strWSAErrorGet = "[gzXgؒfꂽB"
        Case WSAENOBUFS
            strWSAErrorGet = "obt@̈sB"
        Case WSAEISCONN
            strWSAErrorGet = "\Pbg͂łɐڑĂB"
        Case WSAENOTCONN
            strWSAErrorGet = "\PbgڑĂȂB"
        Case WSAESHUTDOWN
            strWSAErrorGet = "\PbgVbg_EĂB"
        Case WSAETIMEDOUT
            strWSAErrorGet = "ڑ^CAEgB"
        Case WSAECONNREFUSED
            strWSAErrorGet = "ڑۂꂽB"
        Case WSAEHOSTDOWN
            strWSAErrorGet = "[gzXg_EĂB"
        Case WSAEHOSTUNREACH
            strWSAErrorGet = "zXgւ̃[g݂ȂB"
        Case WSAEPROCLIM
            strWSAErrorGet = "vZX܂B"
        Case WSASYSNOTREADY
            strWSAErrorGet = "lbg[NTuVXeɒʐM邽߂̏łĂȂB"
        Case WSAVERNOTSUPPORTED
            strWSAErrorGet = "w肳ꂽo[WT|[gĂȂB"
        Case WSANOTINITIALISED
            strWSAErrorGet = "WSAStartup֐ĂяoĂȂAsĂ܂B"
        Case WSAHOST_NOT_FOUND
            strWSAErrorGet = "zXgȂB"
        Case WSATRY_AGAIN
            strWSAErrorGet = "zXgȂB"
        Case WSANO_RECOVERY
            strWSAErrorGet = "Cs\ȃG[B"
        Case WSANO_DATA
            strWSAErrorGet = "f[^R[ȟ^vĂȂB"
        Case Else:
            strWSAErrorGet = "(" & vlngErrNum & ")"
    End Select
End Function

Public Function PutSocket(ByRef mlngSock As Long, ByVal str As String) As Long
    Dim rtn As Long
    Dim strMsg As String
   
    strMsg = ""
    rtn = send(mlngSock, ByVal str & vbCrLf, Len(str & vbCrLf), 0)
    If rtn = SOCKET_ERROR Then
        strMsg = "send:" & strWSAErrorGet(WSAGetLastError())
        MsgBox ("PutSocket : SOCKET_ERROR = " & strMsg)
    End If

End Function
    
Public Function GetSocket(ByRef mlngSock As Long, ByRef str As String) As Long
    Dim rtn As Long
    Dim strRecv As String * 100
    Dim strRecvBuf As String
    Dim strMsg As String
    Dim end_mark As Integer

    strRecvBuf = ""
    
    Do While True
        DoEvents
        rtn = recv(mlngSock, strRecv, 100, 0)
        If (rtn > 0) Then
            end_mark = InStr(1, strRecv, vbCr, vbBinaryCompare)
            If end_mark > 0 Then
                str = Left$(strRecv, end_mark - 1)
            Else
                end_mark = InStr(1, strRecv, vbLf, vbBinaryCompare)
                If end_mark > 0 Then
                    str = Left$(strRecv, end_mark - 1)
                Else
                    str = Left$(strRecv, rtn)
                End If
            End If

            GetSocket = Len(str)
            Exit Do
        ElseIf rtn = SOCKET_ERROR Then
            If WSAGetLastError() > 0 Then
                strRecvBuf = ""
                strMsg = "send:" & strWSAErrorGet(WSAGetLastError())
                MsgBox ("GetSocket : SOCKET_ERROR = " & strMsg)
                GetSocket = SOCKET_ERROR
                Exit Do
            End If
        Else
            GetSocket = RECV_ERROR
            Exit Do
        End If
    Loop
    
End Function

Public Function QrySocket(ByRef mlngSock As Long, ByVal Send_str As String, ByRef Receive_str As String) As Long
    Dim rd_cnt As Long
    
    QrySocket = PutSocket(mlngSock, Send_str)
    If QrySocket < 0 Then Exit Function
    rd_cnt = GetSocket(mlngSock, Receive_str)
    If rd_cnt > 0 Then
        QrySocket = NO_ERROR
    Else
        Receive_str = ""
        QrySocket = rd_cnt
    End If

End Function

